/* File: elapsedTimer.i */
%module elapsedTimer
%{




#include <windows.h>
#include <winbase.h>

#define MSEC_IN_SEC      1000L
#define MSEC_IN_MIN     60000L
#define MSEC_IN_HR    3600000L
#define MSEC_IN_DAY  86400000L

long init()
{
	LPSYSTEMTIME  now;
	GetSystemTime(now);
	return now->wHour   * MSEC_IN_HR
		 + now->wMinute * MSEC_IN_MIN
		 + now->wSecond * MSEC_IN_SEC
		 + now->wMilliseconds;
}


long elapsed(long then)
{
	long nowMs, diff;
	LPSYSTEMTIME  now;
	GetSystemTime(now);
	nowMs =  now->wHour   * MSEC_IN_HR
		   + now->wMinute * MSEC_IN_MIN
	       + now->wSecond * MSEC_IN_SEC
		   + now->wMilliseconds;
	diff = nowMs - then;
	if (diff < 0) diff += MSEC_IN_DAY;
	return diff;
}

%}

long init(void);
long elapsed(long);
