
from crilib import *
import sys
import regex
import serial

class Modem(serial.Port):
    def __init__(self):
        serial.Port.__init__(self)
        self.queryPat = regex.compile('^.*\?$')

    def open(self, cfg):
        self.debug = cfg['debug']
        self._trace('Modem.open')
        cfg['cmdsEchoed'] = TRUE
        cfg['cmdTerm'] = '\r'
        cfg['rspTerm'] = '\r\n'
        cfg['rspType'] = serial.RSP_TERMINATED
        serial.Port.open(self, cfg)
        
    def cmd(self, str=''):
        self._trace('Modem.cmd')
        cmdStr = 'AT' + str
        serial.Port.cmd(self, cmdStr)
        if self.queryPat.match(str) < 0:
            rsp = ok = serial.Port.readTerminated(self)
        else:
            rsp = serial.Port.readTerminated(self)
            serial.Port.readTerminated(self)
            ok = serial.Port.readTerminated(self)
        if ok != 'OK':
            raise serial.SioError, \
                  'Non-OK rsp of %s from modem to cmd %s' % (`ok`, `cmdStr`)
        self._resetBuf(rsp, len(rsp))
        return rsp


def testModem(debug=FALSE):
    d = serial.PortDict()
    d['debug'] = debug
    fd = Modem()
    fd.open(d)
    try:
        print 'get modems attention...',
        sys.stdout.flush()
        rsp = fd.cmd()
        print rsp
        print 'examine first 10 S-Registers...'
        sys.stdout.flush()
        i = 0
        while i < 10:
            str = 'S%03d?' % i
            print '%s = ' % str,
            sys.stdout.flush()
            rsp = fd.cmd(str)
            print rsp
            sys.stdout.flush()
            if i == 0:
                s0 = string.atoi(rsp)
            i = i + 1

        str = 'S000=%d' % (s0 + 1)
        print 'increment S000...',
        sys.stdout.flush()
        rsp = fd.cmd(str)
        print rsp
        sys.stdout.flush()

        str = 'S000?'
        print '%s = ' % str,
        sys.stdout.flush()
        rsp = fd.cmd(str)
        print rsp
        sys.stdout.flush()

        str = 'S000=%d' % s0
        print 'reset S000 to original value...',
        sys.stdout.flush()
        rsp = fd.cmd(str)
        print rsp
        sys.stdout.flush()

        str = 'S000?'
        print '%s = ' % str,
        sys.stdout.flush()
        rsp = fd.cmd(str)
        print rsp
        sys.stdout.flush()

    finally:
        print 'done'
        sys.stdout.flush()
        fd.close()

if __name__ == '__main__': testModem()
