////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:16
//  it declares the content of the module _StdCtrls
////

unit Python_StdCtrls;

interface

uses
   Windows,
   Controls,
   Forms,
   Menus,
   Graphics,
   StdCtrls,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_StdCtrls = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TCustomGroupBox_ReadAttribute( Self : TCustomGroupBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomGroupBox_WriteAttribute( Self : TCustomGroupBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TGroupBox_ReadAttribute( Self : TGroupBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TGroupBox_WriteAttribute( Self : TGroupBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomLabel_ReadAttribute( Self : TCustomLabel; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomLabel_WriteAttribute( Self : TCustomLabel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TLabel_ReadAttribute( Self : TLabel; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TLabel_WriteAttribute( Self : TLabel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomEdit_ReadAttribute( Self : TCustomEdit; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomEdit_WriteAttribute( Self : TCustomEdit; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TEdit_ReadAttribute( Self : TEdit; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TEdit_WriteAttribute( Self : TEdit; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomMemo_ReadAttribute( Self : TCustomMemo; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomMemo_WriteAttribute( Self : TCustomMemo; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TMemo_ReadAttribute( Self : TMemo; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMemo_WriteAttribute( Self : TMemo; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomComboBox_ReadAttribute( Self : TCustomComboBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomComboBox_WriteAttribute( Self : TCustomComboBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TComboBox_ReadAttribute( Self : TComboBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TComboBox_WriteAttribute( Self : TComboBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TButtonControl_ReadAttribute( Self : TButtonControl; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TButtonControl_WriteAttribute( Self : TButtonControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TButton_ReadAttribute( Self : TButton; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TButton_WriteAttribute( Self : TButton; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomCheckBox_ReadAttribute( Self : TCustomCheckBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomCheckBox_WriteAttribute( Self : TCustomCheckBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCheckBox_ReadAttribute( Self : TCheckBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCheckBox_WriteAttribute( Self : TCheckBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TRadioButton_ReadAttribute( Self : TRadioButton; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TRadioButton_WriteAttribute( Self : TRadioButton; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomListBox_ReadAttribute( Self : TCustomListBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomListBox_WriteAttribute( Self : TCustomListBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TListBox_ReadAttribute( Self : TListBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TListBox_WriteAttribute( Self : TListBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TScrollBar_ReadAttribute( Self : TScrollBar; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TScrollBar_WriteAttribute( Self : TScrollBar; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomStaticText_ReadAttribute( Self : TCustomStaticText; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomStaticText_WriteAttribute( Self : TCustomStaticText; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TStaticText_ReadAttribute( Self : TStaticText; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TStaticText_WriteAttribute( Self : TStaticText; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_Classes,
   Python_Classes,
   Delphi_Controls,
   Python_Controls,
   Delphi_Forms,
   Python_Forms,
   Delphi_Menus,
   Python_Menus,
   Delphi_Graphics,
   Python_Graphics,
   Delphi_System,
   Delphi_StdCtrls,
   Python_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gStdCtrls : TModule_StdCtrls;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gStdCtrls := TModule_StdCtrls.Create( AOwner );
  with gStdCtrls do
    begin
      Engine := AEngine;
      ModuleName := '_StdCtrls';
    end;
end;

///////////// Functions for class TCustomGroupBox //////////////////

function TCustomGroupBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomGroupBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomGroupBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomGroupBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomGroupBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomGroupBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomGroupBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomGroupBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomGroupBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomGroupBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomGroupBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomGroupBox' );
      Exit;
    end;
    realObj := TCustomGroupBox(obj);
    // Check attribute
    Result := TCustomGroupBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomGroupBox_ReadAttribute( Self : TCustomGroupBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TCustomControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomGroupBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomGroupBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomGroupBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomGroupBox' );
      Exit;
    end;
    realObj := TCustomGroupBox(obj);
    // Check attribute
    Result := TCustomGroupBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomGroupBox_WriteAttribute( Self : TCustomGroupBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TCustomControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TGroupBox //////////////////

function TGroupBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyGroupBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TGroupBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyGroupBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TGroupBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyGroupBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TGroupBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyGroupBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TGroupBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGroupBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGroupBox) then begin
      ErrorWrongExpectedType( argSelf, 'TGroupBox' );
      Exit;
    end;
    realObj := TGroupBox(obj);
    // Check attribute
    Result := TGroupBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TGroupBox_ReadAttribute( Self : TGroupBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomGroupBox_ReadAttribute( Self, argSelf, key );
  end;
end;

function TGroupBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGroupBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGroupBox) then begin
      ErrorWrongExpectedType( argSelf, 'TGroupBox' );
      Exit;
    end;
    realObj := TGroupBox(obj);
    // Check attribute
    Result := TGroupBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TGroupBox_WriteAttribute( Self : TGroupBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGroupBox then
          with TPyGroupBox(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomGroupBox_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomLabel //////////////////

function TCustomLabel_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomLabel;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomLabel.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomLabel.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomLabel_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomLabel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomLabel) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomLabel' );
      Exit;
    end;
    realObj := TCustomLabel(obj);
    // Check attribute
    Result := TCustomLabel_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomLabel_ReadAttribute( Self : TCustomLabel; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'StdCtrls', 'TCanvas' )
    else Result := TGraphicControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomLabel_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomLabel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomLabel) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomLabel' );
      Exit;
    end;
    realObj := TCustomLabel(obj);
    // Check attribute
    Result := TCustomLabel_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomLabel_WriteAttribute( Self : TCustomLabel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TGraphicControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TLabel //////////////////

function TLabel_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyLabel;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TLabel.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyLabel.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TLabel_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TLabel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TLabel) then begin
      ErrorWrongExpectedType( argSelf, 'TLabel' );
      Exit;
    end;
    realObj := TLabel(obj);
    // Check attribute
    Result := TLabel_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TLabel_ReadAttribute( Self : TLabel; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Alignment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Alignment ) )
    else if CompareText( key, 'AutoSize' ) = 0 then Result := VariantAsPyObject( Self.AutoSize )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'FocusControl' ) = 0 then Result := GetPythonObject( Self.FocusControl, 'StdCtrls', 'TWinControl' )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowAccelChar' ) = 0 then Result := VariantAsPyObject( Self.ShowAccelChar )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Transparent' ) = 0 then Result := VariantAsPyObject( Self.Transparent )
    else if CompareText( key, 'Layout' ) = 0 then Result := VariantAsPyObject( Integer( Self.Layout ) )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'WordWrap' ) = 0 then Result := VariantAsPyObject( Self.WordWrap )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomLabel_ReadAttribute( Self, argSelf, key );
  end;
end;

function TLabel_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TLabel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TLabel) then begin
      ErrorWrongExpectedType( argSelf, 'TLabel' );
      Exit;
    end;
    realObj := TLabel(obj);
    // Check attribute
    Result := TLabel_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TLabel_WriteAttribute( Self : TLabel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Alignment' ) = 0 then begin
      Self.Alignment := TAlignment(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AutoSize' ) = 0 then begin
      Self.AutoSize := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'FocusControl' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TWinControl then begin
        Self.FocusControl := TWinControl( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'FocusControl', 'TWinControl' );
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowAccelChar' ) = 0 then begin
      Self.ShowAccelChar := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Transparent' ) = 0 then begin
      Self.Transparent := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Layout' ) = 0 then begin
      Self.Layout := TTextLayout(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'WordWrap' ) = 0 then begin
      Self.WordWrap := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyLabel then
          with TPyLabel(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomLabel_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomEdit //////////////////

function TCustomEdit_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomEdit;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomEdit.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomEdit.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomEdit_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomEdit;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomEdit.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomEdit.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomEdit_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomEdit;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomEdit) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomEdit' );
      Exit;
    end;
    realObj := TCustomEdit(obj);
    // Check attribute
    Result := TCustomEdit_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomEdit_ReadAttribute( Self : TCustomEdit; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Modified' ) = 0 then Result := VariantAsPyObject( Self.Modified )
    else if CompareText( key, 'SelLength' ) = 0 then Result := VariantAsPyObject( Self.SelLength )
    else if CompareText( key, 'SelStart' ) = 0 then Result := VariantAsPyObject( Self.SelStart )
    else if CompareText( key, 'SelText' ) = 0 then Result := VariantAsPyObject( Self.SelText )
    else if CompareText( key, 'Text' ) = 0 then Result := VariantAsPyObject( Self.Text )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomEdit_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomEdit;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomEdit) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomEdit' );
      Exit;
    end;
    realObj := TCustomEdit(obj);
    // Check attribute
    Result := TCustomEdit_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomEdit_WriteAttribute( Self : TCustomEdit; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Modified' ) = 0 then begin
      Self.Modified := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SelLength' ) = 0 then begin
      Self.SelLength := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SelStart' ) = 0 then begin
      Self.SelStart := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SelText' ) = 0 then begin
      Self.SelText := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Text' ) = 0 then begin
      Self.Text := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TEdit //////////////////

function TEdit_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyEdit;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TEdit.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyEdit.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TEdit_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyEdit;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TEdit.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyEdit.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TEdit_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TEdit;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TEdit) then begin
      ErrorWrongExpectedType( argSelf, 'TEdit' );
      Exit;
    end;
    realObj := TEdit(obj);
    // Check attribute
    Result := TEdit_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TEdit_ReadAttribute( Self : TEdit; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'AutoSelect' ) = 0 then Result := VariantAsPyObject( Self.AutoSelect )
    else if CompareText( key, 'AutoSize' ) = 0 then Result := VariantAsPyObject( Self.AutoSize )
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'CharCase' ) = 0 then Result := VariantAsPyObject( Integer( Self.CharCase ) )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'HideSelection' ) = 0 then Result := VariantAsPyObject( Self.HideSelection )
    else if CompareText( key, 'ImeMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.ImeMode ) )
    else if CompareText( key, 'ImeName' ) = 0 then Result := VariantAsPyObject( Self.ImeName )
    else if CompareText( key, 'MaxLength' ) = 0 then Result := VariantAsPyObject( Self.MaxLength )
    else if CompareText( key, 'OEMConvert' ) = 0 then Result := VariantAsPyObject( Self.OEMConvert )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PasswordChar' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'Char' ); Result := nil; end
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ReadOnly' ) = 0 then Result := VariantAsPyObject( Self.ReadOnly )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Text' ) = 0 then Result := VariantAsPyObject( Self.Text )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomEdit_ReadAttribute( Self, argSelf, key );
  end;
end;

function TEdit_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TEdit;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TEdit) then begin
      ErrorWrongExpectedType( argSelf, 'TEdit' );
      Exit;
    end;
    realObj := TEdit(obj);
    // Check attribute
    Result := TEdit_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TEdit_WriteAttribute( Self : TEdit; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'AutoSelect' ) = 0 then begin
      Self.AutoSelect := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AutoSize' ) = 0 then begin
      Self.AutoSize := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'CharCase' ) = 0 then begin
      Self.CharCase := TEditCharCase(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'HideSelection' ) = 0 then begin
      Self.HideSelection := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ImeMode' ) = 0 then begin
      Self.ImeMode := TImeMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ImeName' ) = 0 then begin
      Self.ImeName := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'MaxLength' ) = 0 then begin
      Self.MaxLength := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OEMConvert' ) = 0 then begin
      Self.OEMConvert := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PasswordChar' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'Char' );
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ReadOnly' ) = 0 then begin
      Self.ReadOnly := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Text' ) = 0 then begin
      Self.Text := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyEdit then
          with TPyEdit(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomEdit_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomMemo //////////////////

function TCustomMemo_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomMemo;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomMemo.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomMemo.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomMemo_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomMemo;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomMemo.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomMemo.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomMemo_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomMemo;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomMemo) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomMemo' );
      Exit;
    end;
    realObj := TCustomMemo(obj);
    // Check attribute
    Result := TCustomMemo_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomMemo_ReadAttribute( Self : TCustomMemo; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Lines' ) = 0 then Result := GetPythonObject( Self.Lines, 'StdCtrls', 'TStrings' )
    else Result := TCustomEdit_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomMemo_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomMemo;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomMemo) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomMemo' );
      Exit;
    end;
    realObj := TCustomMemo(obj);
    // Check attribute
    Result := TCustomMemo_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomMemo_WriteAttribute( Self : TCustomMemo; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Lines' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Lines := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Lines', 'TStrings' );
    end else Result := TCustomEdit_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TMemo //////////////////

function TMemo_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMemo;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TMemo.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMemo.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMemo_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMemo;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TMemo.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMemo.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMemo_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMemo;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMemo) then begin
      ErrorWrongExpectedType( argSelf, 'TMemo' );
      Exit;
    end;
    realObj := TMemo(obj);
    // Check attribute
    Result := TMemo_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMemo_ReadAttribute( Self : TMemo; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Alignment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Alignment ) )
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'HideSelection' ) = 0 then Result := VariantAsPyObject( Self.HideSelection )
    else if CompareText( key, 'ImeMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.ImeMode ) )
    else if CompareText( key, 'ImeName' ) = 0 then Result := VariantAsPyObject( Self.ImeName )
    else if CompareText( key, 'Lines' ) = 0 then Result := GetPythonObject( Self.Lines, 'StdCtrls', 'TStrings' )
    else if CompareText( key, 'MaxLength' ) = 0 then Result := VariantAsPyObject( Self.MaxLength )
    else if CompareText( key, 'OEMConvert' ) = 0 then Result := VariantAsPyObject( Self.OEMConvert )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ReadOnly' ) = 0 then Result := VariantAsPyObject( Self.ReadOnly )
    else if CompareText( key, 'ScrollBars' ) = 0 then Result := VariantAsPyObject( Integer( Self.ScrollBars ) )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'WantReturns' ) = 0 then Result := VariantAsPyObject( Self.WantReturns )
    else if CompareText( key, 'WantTabs' ) = 0 then Result := VariantAsPyObject( Self.WantTabs )
    else if CompareText( key, 'WordWrap' ) = 0 then Result := VariantAsPyObject( Self.WordWrap )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomMemo_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMemo_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMemo;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMemo) then begin
      ErrorWrongExpectedType( argSelf, 'TMemo' );
      Exit;
    end;
    realObj := TMemo(obj);
    // Check attribute
    Result := TMemo_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMemo_WriteAttribute( Self : TMemo; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Alignment' ) = 0 then begin
      Self.Alignment := TAlignment(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'HideSelection' ) = 0 then begin
      Self.HideSelection := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ImeMode' ) = 0 then begin
      Self.ImeMode := TImeMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ImeName' ) = 0 then begin
      Self.ImeName := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Lines' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Lines := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Lines', 'TStrings' );
    end else if CompareText( key, 'MaxLength' ) = 0 then begin
      Self.MaxLength := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OEMConvert' ) = 0 then begin
      Self.OEMConvert := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ReadOnly' ) = 0 then begin
      Self.ReadOnly := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ScrollBars' ) = 0 then begin
      Self.ScrollBars := TScrollStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'WantReturns' ) = 0 then begin
      Self.WantReturns := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'WantTabs' ) = 0 then begin
      Self.WantTabs := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'WordWrap' ) = 0 then begin
      Self.WordWrap := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMemo then
          with TPyMemo(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomMemo_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomComboBox //////////////////

function TCustomComboBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomComboBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomComboBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomComboBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomComboBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomComboBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomComboBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomComboBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomComboBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomComboBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomComboBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomComboBox' );
      Exit;
    end;
    realObj := TCustomComboBox(obj);
    // Check attribute
    Result := TCustomComboBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomComboBox_ReadAttribute( Self : TCustomComboBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'StdCtrls', 'TCanvas' )
    else if CompareText( key, 'DroppedDown' ) = 0 then Result := VariantAsPyObject( Self.DroppedDown )
    else if CompareText( key, 'Items' ) = 0 then Result := GetPythonObject( Self.Items, 'StdCtrls', 'TStrings' )
    else if CompareText( key, 'ItemIndex' ) = 0 then Result := VariantAsPyObject( Self.ItemIndex )
    else if CompareText( key, 'SelLength' ) = 0 then Result := VariantAsPyObject( Self.SelLength )
    else if CompareText( key, 'SelStart' ) = 0 then Result := VariantAsPyObject( Self.SelStart )
    else if CompareText( key, 'SelText' ) = 0 then Result := VariantAsPyObject( Self.SelText )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomComboBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomComboBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomComboBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomComboBox' );
      Exit;
    end;
    realObj := TCustomComboBox(obj);
    // Check attribute
    Result := TCustomComboBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomComboBox_WriteAttribute( Self : TCustomComboBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'DroppedDown' ) = 0 then begin
      Self.DroppedDown := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Items' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Items := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Items', 'TStrings' );
    end else if CompareText( key, 'ItemIndex' ) = 0 then begin
      Self.ItemIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SelLength' ) = 0 then begin
      Self.SelLength := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SelStart' ) = 0 then begin
      Self.SelStart := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SelText' ) = 0 then begin
      Self.SelText := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TComboBox //////////////////

function TComboBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyComboBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TComboBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyComboBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TComboBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyComboBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TComboBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyComboBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TComboBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TComboBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TComboBox) then begin
      ErrorWrongExpectedType( argSelf, 'TComboBox' );
      Exit;
    end;
    realObj := TComboBox(obj);
    // Check attribute
    Result := TComboBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TComboBox_ReadAttribute( Self : TComboBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Style' ) = 0 then Result := VariantAsPyObject( Integer( Self.Style ) )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DropDownCount' ) = 0 then Result := VariantAsPyObject( Self.DropDownCount )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ImeMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.ImeMode ) )
    else if CompareText( key, 'ImeName' ) = 0 then Result := VariantAsPyObject( Self.ImeName )
    else if CompareText( key, 'ItemHeight' ) = 0 then Result := VariantAsPyObject( Self.ItemHeight )
    else if CompareText( key, 'Items' ) = 0 then Result := GetPythonObject( Self.Items, 'StdCtrls', 'TStrings' )
    else if CompareText( key, 'MaxLength' ) = 0 then Result := VariantAsPyObject( Self.MaxLength )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Sorted' ) = 0 then Result := VariantAsPyObject( Self.Sorted )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Text' ) = 0 then Result := VariantAsPyObject( Self.Text )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnDrawItem' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDrawItemEvent' ); Result := nil; end
    else if CompareText( key, 'OnDropDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMeasureItem' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMeasureItemEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomComboBox_ReadAttribute( Self, argSelf, key );
  end;
end;

function TComboBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TComboBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TComboBox) then begin
      ErrorWrongExpectedType( argSelf, 'TComboBox' );
      Exit;
    end;
    realObj := TComboBox(obj);
    // Check attribute
    Result := TComboBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TComboBox_WriteAttribute( Self : TComboBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Style' ) = 0 then begin
      Self.Style := TComboBoxStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DropDownCount' ) = 0 then begin
      Self.DropDownCount := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ImeMode' ) = 0 then begin
      Self.ImeMode := TImeMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ImeName' ) = 0 then begin
      Self.ImeName := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ItemHeight' ) = 0 then begin
      Self.ItemHeight := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Items' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Items := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Items', 'TStrings' );
    end else if CompareText( key, 'MaxLength' ) = 0 then begin
      Self.MaxLength := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Sorted' ) = 0 then begin
      Self.Sorted := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Text' ) = 0 then begin
      Self.Text := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDrawItem' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDrawItem := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnDrawItem := EventOnDrawItem;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDropDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDropDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnDropDown := EventOnDropDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMeasureItem' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMeasureItem := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnMeasureItem := EventOnMeasureItem;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyComboBox then
          with TPyComboBox(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomComboBox_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TButtonControl //////////////////

function TButtonControl_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyButtonControl;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TButtonControl.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyButtonControl.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TButtonControl_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyButtonControl;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TButtonControl.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyButtonControl.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TButtonControl_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TButtonControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TButtonControl) then begin
      ErrorWrongExpectedType( argSelf, 'TButtonControl' );
      Exit;
    end;
    realObj := TButtonControl(obj);
    // Check attribute
    Result := TButtonControl_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TButtonControl_ReadAttribute( Self : TButtonControl; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TButtonControl_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TButtonControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TButtonControl) then begin
      ErrorWrongExpectedType( argSelf, 'TButtonControl' );
      Exit;
    end;
    realObj := TButtonControl(obj);
    // Check attribute
    Result := TButtonControl_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TButtonControl_WriteAttribute( Self : TButtonControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TButton //////////////////

function TButton_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyButton;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TButton.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyButton.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TButton_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyButton;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TButton.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyButton.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TButton_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TButton;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TButton) then begin
      ErrorWrongExpectedType( argSelf, 'TButton' );
      Exit;
    end;
    realObj := TButton(obj);
    // Check attribute
    Result := TButton_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TButton_ReadAttribute( Self : TButton; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Cancel' ) = 0 then Result := VariantAsPyObject( Self.Cancel )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Default' ) = 0 then Result := VariantAsPyObject( Self.Default )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ModalResult' ) = 0 then Result := VariantAsPyObject( Integer( Self.ModalResult ) )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TButtonControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TButton_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TButton;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TButton) then begin
      ErrorWrongExpectedType( argSelf, 'TButton' );
      Exit;
    end;
    realObj := TButton(obj);
    // Check attribute
    Result := TButton_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TButton_WriteAttribute( Self : TButton; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Cancel' ) = 0 then begin
      Self.Cancel := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Default' ) = 0 then begin
      Self.Default := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ModalResult' ) = 0 then begin
      Self.ModalResult := TModalResult(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyButton then
          with TPyButton(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TButtonControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomCheckBox //////////////////

function TCustomCheckBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomCheckBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomCheckBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomCheckBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomCheckBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomCheckBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomCheckBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomCheckBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomCheckBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomCheckBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomCheckBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomCheckBox' );
      Exit;
    end;
    realObj := TCustomCheckBox(obj);
    // Check attribute
    Result := TCustomCheckBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomCheckBox_ReadAttribute( Self : TCustomCheckBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else Result := TButtonControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomCheckBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomCheckBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomCheckBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomCheckBox' );
      Exit;
    end;
    realObj := TCustomCheckBox(obj);
    // Check attribute
    Result := TCustomCheckBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomCheckBox_WriteAttribute( Self : TCustomCheckBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TButtonControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCheckBox //////////////////

function TCheckBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCheckBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCheckBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCheckBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCheckBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCheckBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCheckBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCheckBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCheckBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCheckBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCheckBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCheckBox' );
      Exit;
    end;
    realObj := TCheckBox(obj);
    // Check attribute
    Result := TCheckBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCheckBox_ReadAttribute( Self : TCheckBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Alignment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Alignment ) )
    else if CompareText( key, 'AllowGrayed' ) = 0 then Result := VariantAsPyObject( Self.AllowGrayed )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Checked' ) = 0 then Result := VariantAsPyObject( Self.Checked )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'State' ) = 0 then Result := VariantAsPyObject( Integer( Self.State ) )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomCheckBox_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCheckBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCheckBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCheckBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCheckBox' );
      Exit;
    end;
    realObj := TCheckBox(obj);
    // Check attribute
    Result := TCheckBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCheckBox_WriteAttribute( Self : TCheckBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Alignment' ) = 0 then begin
      Self.Alignment := TLeftRight(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AllowGrayed' ) = 0 then begin
      Self.AllowGrayed := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Checked' ) = 0 then begin
      Self.Checked := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'State' ) = 0 then begin
      Self.State := TCheckBoxState(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCheckBox then
          with TPyCheckBox(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomCheckBox_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TRadioButton //////////////////

function TRadioButton_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyRadioButton;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TRadioButton.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyRadioButton.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TRadioButton_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyRadioButton;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TRadioButton.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyRadioButton.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TRadioButton_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TRadioButton;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TRadioButton) then begin
      ErrorWrongExpectedType( argSelf, 'TRadioButton' );
      Exit;
    end;
    realObj := TRadioButton(obj);
    // Check attribute
    Result := TRadioButton_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TRadioButton_ReadAttribute( Self : TRadioButton; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Alignment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Alignment ) )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Checked' ) = 0 then Result := VariantAsPyObject( Self.Checked )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TButtonControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TRadioButton_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TRadioButton;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TRadioButton) then begin
      ErrorWrongExpectedType( argSelf, 'TRadioButton' );
      Exit;
    end;
    realObj := TRadioButton(obj);
    // Check attribute
    Result := TRadioButton_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TRadioButton_WriteAttribute( Self : TRadioButton; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Alignment' ) = 0 then begin
      Self.Alignment := TLeftRight(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Checked' ) = 0 then begin
      Self.Checked := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioButton then
          with TPyRadioButton(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TButtonControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomListBox //////////////////

function TCustomListBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomListBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomListBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomListBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomListBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomListBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomListBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomListBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomListBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomListBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomListBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomListBox' );
      Exit;
    end;
    realObj := TCustomListBox(obj);
    // Check attribute
    Result := TCustomListBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomListBox_ReadAttribute( Self : TCustomListBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'StdCtrls', 'TCanvas' )
    else if CompareText( key, 'Items' ) = 0 then Result := GetPythonObject( Self.Items, 'StdCtrls', 'TStrings' )
    else if CompareText( key, 'ItemIndex' ) = 0 then Result := VariantAsPyObject( Self.ItemIndex )
    else if CompareText( key, 'SelCount' ) = 0 then Result := VariantAsPyObject( Self.SelCount )
    else if CompareText( key, 'TopIndex' ) = 0 then Result := VariantAsPyObject( Self.TopIndex )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomListBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomListBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomListBox) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomListBox' );
      Exit;
    end;
    realObj := TCustomListBox(obj);
    // Check attribute
    Result := TCustomListBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomListBox_WriteAttribute( Self : TCustomListBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Items' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Items := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Items', 'TStrings' );
    end else if CompareText( key, 'ItemIndex' ) = 0 then begin
      Self.ItemIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SelCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'TopIndex' ) = 0 then begin
      Self.TopIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TListBox //////////////////

function TListBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyListBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TListBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyListBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TListBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyListBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TListBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyListBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TListBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TListBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TListBox) then begin
      ErrorWrongExpectedType( argSelf, 'TListBox' );
      Exit;
    end;
    realObj := TListBox(obj);
    // Check attribute
    Result := TListBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TListBox_ReadAttribute( Self : TListBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Columns' ) = 0 then Result := VariantAsPyObject( Self.Columns )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'ExtendedSelect' ) = 0 then Result := VariantAsPyObject( Self.ExtendedSelect )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ImeMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.ImeMode ) )
    else if CompareText( key, 'ImeName' ) = 0 then Result := VariantAsPyObject( Self.ImeName )
    else if CompareText( key, 'IntegralHeight' ) = 0 then Result := VariantAsPyObject( Self.IntegralHeight )
    else if CompareText( key, 'ItemHeight' ) = 0 then Result := VariantAsPyObject( Self.ItemHeight )
    else if CompareText( key, 'Items' ) = 0 then Result := GetPythonObject( Self.Items, 'StdCtrls', 'TStrings' )
    else if CompareText( key, 'MultiSelect' ) = 0 then Result := VariantAsPyObject( Self.MultiSelect )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Sorted' ) = 0 then Result := VariantAsPyObject( Self.Sorted )
    else if CompareText( key, 'Style' ) = 0 then Result := VariantAsPyObject( Integer( Self.Style ) )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'TabWidth' ) = 0 then Result := VariantAsPyObject( Self.TabWidth )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnDrawItem' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDrawItemEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMeasureItem' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMeasureItemEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomListBox_ReadAttribute( Self, argSelf, key );
  end;
end;

function TListBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TListBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TListBox) then begin
      ErrorWrongExpectedType( argSelf, 'TListBox' );
      Exit;
    end;
    realObj := TListBox(obj);
    // Check attribute
    Result := TListBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TListBox_WriteAttribute( Self : TListBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Columns' ) = 0 then begin
      Self.Columns := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ExtendedSelect' ) = 0 then begin
      Self.ExtendedSelect := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ImeMode' ) = 0 then begin
      Self.ImeMode := TImeMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ImeName' ) = 0 then begin
      Self.ImeName := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'IntegralHeight' ) = 0 then begin
      Self.IntegralHeight := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ItemHeight' ) = 0 then begin
      Self.ItemHeight := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Items' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Items := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Items', 'TStrings' );
    end else if CompareText( key, 'MultiSelect' ) = 0 then begin
      Self.MultiSelect := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Sorted' ) = 0 then begin
      Self.Sorted := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Style' ) = 0 then begin
      Self.Style := TListBoxStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabWidth' ) = 0 then begin
      Self.TabWidth := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDrawItem' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDrawItem := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnDrawItem := EventOnDrawItem;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMeasureItem' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMeasureItem := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnMeasureItem := EventOnMeasureItem;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyListBox then
          with TPyListBox(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomListBox_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TScrollBar //////////////////

function TScrollBar_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyScrollBar;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TScrollBar.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyScrollBar.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TScrollBar_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyScrollBar;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TScrollBar.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyScrollBar.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TScrollBar_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScrollBar;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScrollBar) then begin
      ErrorWrongExpectedType( argSelf, 'TScrollBar' );
      Exit;
    end;
    realObj := TScrollBar(obj);
    // Check attribute
    Result := TScrollBar_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TScrollBar_ReadAttribute( Self : TScrollBar; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Kind' ) = 0 then Result := VariantAsPyObject( Integer( Self.Kind ) )
    else if CompareText( key, 'LargeChange' ) = 0 then Result := VariantAsPyObject( Integer( Self.LargeChange ) )
    else if CompareText( key, 'Max' ) = 0 then Result := VariantAsPyObject( Self.Max )
    else if CompareText( key, 'Min' ) = 0 then Result := VariantAsPyObject( Self.Min )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'Position' ) = 0 then Result := VariantAsPyObject( Self.Position )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'SmallChange' ) = 0 then Result := VariantAsPyObject( Integer( Self.SmallChange ) )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnScroll' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TScrollEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TScrollBar_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScrollBar;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScrollBar) then begin
      ErrorWrongExpectedType( argSelf, 'TScrollBar' );
      Exit;
    end;
    realObj := TScrollBar(obj);
    // Check attribute
    Result := TScrollBar_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TScrollBar_WriteAttribute( Self : TScrollBar; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Kind' ) = 0 then begin
      Self.Kind := TScrollBarKind(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'LargeChange' ) = 0 then begin
      Self.LargeChange := TScrollBarInc(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Max' ) = 0 then begin
      Self.Max := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Min' ) = 0 then begin
      Self.Min := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'Position' ) = 0 then begin
      Self.Position := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'SmallChange' ) = 0 then begin
      Self.SmallChange := TScrollBarInc(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnScroll' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnScroll := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnScroll := EventOnScroll;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBar then
          with TPyScrollBar(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomStaticText //////////////////

function TCustomStaticText_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomStaticText;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomStaticText.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomStaticText.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomStaticText_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomStaticText;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomStaticText.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomStaticText.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomStaticText_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomStaticText;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomStaticText) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomStaticText' );
      Exit;
    end;
    realObj := TCustomStaticText(obj);
    // Check attribute
    Result := TCustomStaticText_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomStaticText_ReadAttribute( Self : TCustomStaticText; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomStaticText_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomStaticText;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomStaticText) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomStaticText' );
      Exit;
    end;
    realObj := TCustomStaticText(obj);
    // Check attribute
    Result := TCustomStaticText_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomStaticText_WriteAttribute( Self : TCustomStaticText; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TStaticText //////////////////

function TStaticText_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyStaticText;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TStaticText.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyStaticText.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TStaticText_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyStaticText;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TStaticText.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyStaticText.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TStaticText_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStaticText;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStaticText) then begin
      ErrorWrongExpectedType( argSelf, 'TStaticText' );
      Exit;
    end;
    realObj := TStaticText(obj);
    // Check attribute
    Result := TStaticText_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TStaticText_ReadAttribute( Self : TStaticText; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Alignment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Alignment ) )
    else if CompareText( key, 'AutoSize' ) = 0 then Result := VariantAsPyObject( Self.AutoSize )
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'FocusControl' ) = 0 then Result := GetPythonObject( Self.FocusControl, 'StdCtrls', 'TWinControl' )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'StdCtrls', 'TFont' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'StdCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowAccelChar' ) = 0 then Result := VariantAsPyObject( Self.ShowAccelChar )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomStaticText_ReadAttribute( Self, argSelf, key );
  end;
end;

function TStaticText_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TStaticText;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TStaticText) then begin
      ErrorWrongExpectedType( argSelf, 'TStaticText' );
      Exit;
    end;
    realObj := TStaticText(obj);
    // Check attribute
    Result := TStaticText_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TStaticText_WriteAttribute( Self : TStaticText; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Alignment' ) = 0 then begin
      Self.Alignment := TAlignment(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AutoSize' ) = 0 then begin
      Self.AutoSize := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TStaticBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'FocusControl' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TWinControl then begin
        Self.FocusControl := TWinControl( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'FocusControl', 'TWinControl' );
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowAccelChar' ) = 0 then begin
      Self.ShowAccelChar := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyStaticText then
          with TPyStaticText(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomStaticText_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_StdCtrls.Initialize;
begin
  AddMethod( 'CreateCustomGroupBox', TCustomGroupBox_Create, '' );
  AddMethod( 'CreateParentedCustomGroupBox', TCustomGroupBox_CreateParented, '' );
  AddMethod( 'CustomGroupBox_GetAttr', TCustomGroupBox_GetAttr, '' );
  AddMethod( 'CustomGroupBox_SetAttr', TCustomGroupBox_SetAttr, '' );
  AddMethod( 'CreateGroupBox', TGroupBox_Create, '' );
  AddMethod( 'CreateParentedGroupBox', TGroupBox_CreateParented, '' );
  AddMethod( 'GroupBox_GetAttr', TGroupBox_GetAttr, '' );
  AddMethod( 'GroupBox_SetAttr', TGroupBox_SetAttr, '' );
  AddMethod( 'CreateCustomLabel', TCustomLabel_Create, '' );
  AddMethod( 'CustomLabel_GetAttr', TCustomLabel_GetAttr, '' );
  AddMethod( 'CustomLabel_SetAttr', TCustomLabel_SetAttr, '' );
  AddMethod( 'CreateLabel', TLabel_Create, '' );
  AddMethod( 'Label_GetAttr', TLabel_GetAttr, '' );
  AddMethod( 'Label_SetAttr', TLabel_SetAttr, '' );
  AddMethod( 'CreateCustomEdit', TCustomEdit_Create, '' );
  AddMethod( 'CreateParentedCustomEdit', TCustomEdit_CreateParented, '' );
  AddMethod( 'CustomEdit_GetAttr', TCustomEdit_GetAttr, '' );
  AddMethod( 'CustomEdit_SetAttr', TCustomEdit_SetAttr, '' );
  AddMethod( 'CreateEdit', TEdit_Create, '' );
  AddMethod( 'CreateParentedEdit', TEdit_CreateParented, '' );
  AddMethod( 'Edit_GetAttr', TEdit_GetAttr, '' );
  AddMethod( 'Edit_SetAttr', TEdit_SetAttr, '' );
  AddMethod( 'CreateCustomMemo', TCustomMemo_Create, '' );
  AddMethod( 'CreateParentedCustomMemo', TCustomMemo_CreateParented, '' );
  AddMethod( 'CustomMemo_GetAttr', TCustomMemo_GetAttr, '' );
  AddMethod( 'CustomMemo_SetAttr', TCustomMemo_SetAttr, '' );
  AddMethod( 'CreateMemo', TMemo_Create, '' );
  AddMethod( 'CreateParentedMemo', TMemo_CreateParented, '' );
  AddMethod( 'Memo_GetAttr', TMemo_GetAttr, '' );
  AddMethod( 'Memo_SetAttr', TMemo_SetAttr, '' );
  AddMethod( 'CreateCustomComboBox', TCustomComboBox_Create, '' );
  AddMethod( 'CreateParentedCustomComboBox', TCustomComboBox_CreateParented, '' );
  AddMethod( 'CustomComboBox_GetAttr', TCustomComboBox_GetAttr, '' );
  AddMethod( 'CustomComboBox_SetAttr', TCustomComboBox_SetAttr, '' );
  AddMethod( 'CreateComboBox', TComboBox_Create, '' );
  AddMethod( 'CreateParentedComboBox', TComboBox_CreateParented, '' );
  AddMethod( 'ComboBox_GetAttr', TComboBox_GetAttr, '' );
  AddMethod( 'ComboBox_SetAttr', TComboBox_SetAttr, '' );
  AddMethod( 'CreateButtonControl', TButtonControl_Create, '' );
  AddMethod( 'CreateParentedButtonControl', TButtonControl_CreateParented, '' );
  AddMethod( 'ButtonControl_GetAttr', TButtonControl_GetAttr, '' );
  AddMethod( 'ButtonControl_SetAttr', TButtonControl_SetAttr, '' );
  AddMethod( 'CreateButton', TButton_Create, '' );
  AddMethod( 'CreateParentedButton', TButton_CreateParented, '' );
  AddMethod( 'Button_GetAttr', TButton_GetAttr, '' );
  AddMethod( 'Button_SetAttr', TButton_SetAttr, '' );
  AddMethod( 'CreateCustomCheckBox', TCustomCheckBox_Create, '' );
  AddMethod( 'CreateParentedCustomCheckBox', TCustomCheckBox_CreateParented, '' );
  AddMethod( 'CustomCheckBox_GetAttr', TCustomCheckBox_GetAttr, '' );
  AddMethod( 'CustomCheckBox_SetAttr', TCustomCheckBox_SetAttr, '' );
  AddMethod( 'CreateCheckBox', TCheckBox_Create, '' );
  AddMethod( 'CreateParentedCheckBox', TCheckBox_CreateParented, '' );
  AddMethod( 'CheckBox_GetAttr', TCheckBox_GetAttr, '' );
  AddMethod( 'CheckBox_SetAttr', TCheckBox_SetAttr, '' );
  AddMethod( 'CreateRadioButton', TRadioButton_Create, '' );
  AddMethod( 'CreateParentedRadioButton', TRadioButton_CreateParented, '' );
  AddMethod( 'RadioButton_GetAttr', TRadioButton_GetAttr, '' );
  AddMethod( 'RadioButton_SetAttr', TRadioButton_SetAttr, '' );
  AddMethod( 'CreateCustomListBox', TCustomListBox_Create, '' );
  AddMethod( 'CreateParentedCustomListBox', TCustomListBox_CreateParented, '' );
  AddMethod( 'CustomListBox_GetAttr', TCustomListBox_GetAttr, '' );
  AddMethod( 'CustomListBox_SetAttr', TCustomListBox_SetAttr, '' );
  AddMethod( 'CreateListBox', TListBox_Create, '' );
  AddMethod( 'CreateParentedListBox', TListBox_CreateParented, '' );
  AddMethod( 'ListBox_GetAttr', TListBox_GetAttr, '' );
  AddMethod( 'ListBox_SetAttr', TListBox_SetAttr, '' );
  AddMethod( 'CreateScrollBar', TScrollBar_Create, '' );
  AddMethod( 'CreateParentedScrollBar', TScrollBar_CreateParented, '' );
  AddMethod( 'ScrollBar_GetAttr', TScrollBar_GetAttr, '' );
  AddMethod( 'ScrollBar_SetAttr', TScrollBar_SetAttr, '' );
  AddMethod( 'CreateCustomStaticText', TCustomStaticText_Create, '' );
  AddMethod( 'CreateParentedCustomStaticText', TCustomStaticText_CreateParented, '' );
  AddMethod( 'CustomStaticText_GetAttr', TCustomStaticText_GetAttr, '' );
  AddMethod( 'CustomStaticText_SetAttr', TCustomStaticText_SetAttr, '' );
  AddMethod( 'CreateStaticText', TStaticText_Create, '' );
  AddMethod( 'CreateParentedStaticText', TStaticText_CreateParented, '' );
  AddMethod( 'StaticText_GetAttr', TStaticText_GetAttr, '' );
  AddMethod( 'StaticText_SetAttr', TStaticText_SetAttr, '' );
  inherited;
end;

end.
