////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:21
//  it declares the content of the module _Menus
////

unit Python_Menus;

interface

uses
   Windows,
   Menus,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_Menus = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TMenuItem_ReadAttribute( Self : TMenuItem; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMenuItem_WriteAttribute( Self : TMenuItem; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TMenu_ReadAttribute( Self : TMenu; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMenu_WriteAttribute( Self : TMenu; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TMainMenu_ReadAttribute( Self : TMainMenu; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMainMenu_WriteAttribute( Self : TMainMenu; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TPopupMenu_ReadAttribute( Self : TPopupMenu; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TPopupMenu_WriteAttribute( Self : TPopupMenu; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_Classes,
   Python_Classes,
   Delphi_System,
   Delphi_Menus,
   Python_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gMenus : TModule_Menus;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gMenus := TModule_Menus.Create( AOwner );
  with gMenus do
    begin
      Engine := AEngine;
      ModuleName := '_Menus';
    end;
end;

///////////// Functions for class TMenuItem //////////////////

function TMenuItem_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMenuItem;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TMenuItem.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMenuItem.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMenuItem_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMenuItem;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMenuItem) then begin
      ErrorWrongExpectedType( argSelf, 'TMenuItem' );
      Exit;
    end;
    realObj := TMenuItem(obj);
    // Check attribute
    Result := TMenuItem_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMenuItem_ReadAttribute( Self : TMenuItem; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Command' ) = 0 then Result := VariantAsPyObject( Self.Command )
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HMENU' ); Result := nil; end
    else if CompareText( key, 'Count' ) = 0 then Result := VariantAsPyObject( Self.Count )
    else if CompareText( key, 'MenuIndex' ) = 0 then Result := VariantAsPyObject( Self.MenuIndex )
    else if CompareText( key, 'Parent' ) = 0 then Result := GetPythonObject( Self.Parent, 'Menus', 'TMenuItem' )
    else if CompareText( key, 'Break' ) = 0 then Result := VariantAsPyObject( Integer( Self.Break ) )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Checked' ) = 0 then Result := VariantAsPyObject( Self.Checked )
    else if CompareText( key, 'Default' ) = 0 then Result := VariantAsPyObject( Self.Default )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'GroupIndex' ) = 0 then Result := VariantAsPyObject( Self.GroupIndex )
    else if CompareText( key, 'HelpContext' ) = 0 then Result := VariantAsPyObject( Integer( Self.HelpContext ) )
    else if CompareText( key, 'Hint' ) = 0 then Result := VariantAsPyObject( Self.Hint )
    else if CompareText( key, 'RadioItem' ) = 0 then Result := VariantAsPyObject( Self.RadioItem )
    else if CompareText( key, 'ShortCut' ) = 0 then Result := VariantAsPyObject( Integer( Self.ShortCut ) )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMenuItem_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMenuItem;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMenuItem) then begin
      ErrorWrongExpectedType( argSelf, 'TMenuItem' );
      Exit;
    end;
    realObj := TMenuItem(obj);
    // Check attribute
    Result := TMenuItem_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMenuItem_WriteAttribute( Self : TMenuItem; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Command' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Count' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'MenuIndex' ) = 0 then begin
      Self.MenuIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Parent' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Break' ) = 0 then begin
      Self.Break := TMenuBreak(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Checked' ) = 0 then begin
      Self.Checked := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Default' ) = 0 then begin
      Self.Default := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'GroupIndex' ) = 0 then begin
      Self.GroupIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HelpContext' ) = 0 then begin
      Self.HelpContext := THelpContext(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Hint' ) = 0 then begin
      Self.Hint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'RadioItem' ) = 0 then begin
      Self.RadioItem := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShortCut' ) = 0 then begin
      Self.ShortCut := TShortCut(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyMenuItem then
          with TPyMenuItem(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TMenu //////////////////

function TMenu_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMenu;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TMenu.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMenu.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMenu_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMenu;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMenu) then begin
      ErrorWrongExpectedType( argSelf, 'TMenu' );
      Exit;
    end;
    realObj := TMenu(obj);
    // Check attribute
    Result := TMenu_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMenu_ReadAttribute( Self : TMenu; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HMENU' ); Result := nil; end
    else if CompareText( key, 'WindowHandle' ) = 0 then Result := VariantAsPyObject( Self.WindowHandle )
    else if CompareText( key, 'Items' ) = 0 then Result := GetPythonObject( Self.Items, 'Menus', 'TMenuItem' )
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMenu_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMenu;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMenu) then begin
      ErrorWrongExpectedType( argSelf, 'TMenu' );
      Exit;
    end;
    realObj := TMenu(obj);
    // Check attribute
    Result := TMenu_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMenu_WriteAttribute( Self : TMenu; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'WindowHandle' ) = 0 then begin
      Self.WindowHandle := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Items' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TMainMenu //////////////////

function TMainMenu_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMainMenu;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TMainMenu.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMainMenu.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMainMenu_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMainMenu;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMainMenu) then begin
      ErrorWrongExpectedType( argSelf, 'TMainMenu' );
      Exit;
    end;
    realObj := TMainMenu(obj);
    // Check attribute
    Result := TMainMenu_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMainMenu_ReadAttribute( Self : TMainMenu; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'AutoMerge' ) = 0 then Result := VariantAsPyObject( Self.AutoMerge )
    else Result := TMenu_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMainMenu_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMainMenu;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMainMenu) then begin
      ErrorWrongExpectedType( argSelf, 'TMainMenu' );
      Exit;
    end;
    realObj := TMainMenu(obj);
    // Check attribute
    Result := TMainMenu_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMainMenu_WriteAttribute( Self : TMainMenu; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'AutoMerge' ) = 0 then begin
      Self.AutoMerge := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TMenu_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TPopupMenu //////////////////

function TPopupMenu_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPopupMenu;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TPopupMenu.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPopupMenu.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPopupMenu_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPopupMenu;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPopupMenu) then begin
      ErrorWrongExpectedType( argSelf, 'TPopupMenu' );
      Exit;
    end;
    realObj := TPopupMenu(obj);
    // Check attribute
    Result := TPopupMenu_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TPopupMenu_ReadAttribute( Self : TPopupMenu; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'PopupComponent' ) = 0 then Result := GetPythonObject( Self.PopupComponent, 'Menus', 'TComponent' )
    else if CompareText( key, 'Alignment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Alignment ) )
    else if CompareText( key, 'AutoPopup' ) = 0 then Result := VariantAsPyObject( Self.AutoPopup )
    else if CompareText( key, 'HelpContext' ) = 0 then Result := VariantAsPyObject( Integer( Self.HelpContext ) )
    else if CompareText( key, 'OnPopup' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TMenu_ReadAttribute( Self, argSelf, key );
  end;
end;

function TPopupMenu_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPopupMenu;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPopupMenu) then begin
      ErrorWrongExpectedType( argSelf, 'TPopupMenu' );
      Exit;
    end;
    realObj := TPopupMenu(obj);
    // Check attribute
    Result := TPopupMenu_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TPopupMenu_WriteAttribute( Self : TPopupMenu; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'PopupComponent' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TComponent then begin
        Self.PopupComponent := TComponent( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupComponent', 'TComponent' );
    end else if CompareText( key, 'Alignment' ) = 0 then begin
      Self.Alignment := TPopupAlignment(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AutoPopup' ) = 0 then begin
      Self.AutoPopup := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HelpContext' ) = 0 then begin
      Self.HelpContext := THelpContext(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnPopup' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnPopup := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPopupMenu then
          with TPyPopupMenu(Self) do
            OnPopup := EventOnPopup;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TMenu_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_Menus.Initialize;
begin
  AddMethod( 'CreateMenuItem', TMenuItem_Create, '' );
  AddMethod( 'MenuItem_GetAttr', TMenuItem_GetAttr, '' );
  AddMethod( 'MenuItem_SetAttr', TMenuItem_SetAttr, '' );
  AddMethod( 'CreateMenu', TMenu_Create, '' );
  AddMethod( 'Menu_GetAttr', TMenu_GetAttr, '' );
  AddMethod( 'Menu_SetAttr', TMenu_SetAttr, '' );
  AddMethod( 'CreateMainMenu', TMainMenu_Create, '' );
  AddMethod( 'MainMenu_GetAttr', TMainMenu_GetAttr, '' );
  AddMethod( 'MainMenu_SetAttr', TMainMenu_SetAttr, '' );
  AddMethod( 'CreatePopupMenu', TPopupMenu_Create, '' );
  AddMethod( 'PopupMenu_GetAttr', TPopupMenu_GetAttr, '' );
  AddMethod( 'PopupMenu_SetAttr', TPopupMenu_SetAttr, '' );
  inherited;
end;

end.
