////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:21
//  it declares the content of the module _ExtCtrls
////

unit Python_ExtCtrls;

interface

uses
   Windows,
   Controls,
   Forms,
   Menus,
   Graphics,
   StdCtrls,
   ExtCtrls,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_ExtCtrls = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TShape_ReadAttribute( Self : TShape; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TShape_WriteAttribute( Self : TShape; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TPaintBox_ReadAttribute( Self : TPaintBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TPaintBox_WriteAttribute( Self : TPaintBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TImage_ReadAttribute( Self : TImage; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TImage_WriteAttribute( Self : TImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TBevel_ReadAttribute( Self : TBevel; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TBevel_WriteAttribute( Self : TBevel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TTimer_ReadAttribute( Self : TTimer; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TTimer_WriteAttribute( Self : TTimer; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomPanel_ReadAttribute( Self : TCustomPanel; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomPanel_WriteAttribute( Self : TCustomPanel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TPanel_ReadAttribute( Self : TPanel; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TPanel_WriteAttribute( Self : TPanel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TPage_ReadAttribute( Self : TPage; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TPage_WriteAttribute( Self : TPage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TNotebook_ReadAttribute( Self : TNotebook; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TNotebook_WriteAttribute( Self : TNotebook; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function THeader_ReadAttribute( Self : THeader; argSelf : PPyObject; key : PChar ) : PPyObject;
  function THeader_WriteAttribute( Self : THeader; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomRadioGroup_ReadAttribute( Self : TCustomRadioGroup; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomRadioGroup_WriteAttribute( Self : TCustomRadioGroup; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TRadioGroup_ReadAttribute( Self : TRadioGroup; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TRadioGroup_WriteAttribute( Self : TRadioGroup; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TSplitter_ReadAttribute( Self : TSplitter; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TSplitter_WriteAttribute( Self : TSplitter; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_Classes,
   Python_Classes,
   Delphi_Controls,
   Python_Controls,
   Delphi_Forms,
   Python_Forms,
   Delphi_Menus,
   Python_Menus,
   Delphi_Graphics,
   Python_Graphics,
   Delphi_StdCtrls,
   Python_StdCtrls,
   Delphi_System,
   Delphi_ExtCtrls,
   Python_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gExtCtrls : TModule_ExtCtrls;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gExtCtrls := TModule_ExtCtrls.Create( AOwner );
  with gExtCtrls do
    begin
      Engine := AEngine;
      ModuleName := '_ExtCtrls';
    end;
end;

///////////// Functions for class TShape //////////////////

function TShape_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyShape;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TShape.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyShape.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TShape_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TShape;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TShape) then begin
      ErrorWrongExpectedType( argSelf, 'TShape' );
      Exit;
    end;
    realObj := TShape(obj);
    // Check attribute
    Result := TShape_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TShape_ReadAttribute( Self : TShape; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Brush' ) = 0 then Result := GetPythonObject( Self.Brush, 'ExtCtrls', 'TBrush' )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'Pen' ) = 0 then Result := GetPythonObject( Self.Pen, 'ExtCtrls', 'TPen' )
    else if CompareText( key, 'Shape' ) = 0 then Result := VariantAsPyObject( Integer( Self.Shape ) )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TGraphicControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TShape_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TShape;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TShape) then begin
      ErrorWrongExpectedType( argSelf, 'TShape' );
      Exit;
    end;
    realObj := TShape(obj);
    // Check attribute
    Result := TShape_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TShape_WriteAttribute( Self : TShape; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Brush' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TBrush then begin
        Self.Brush := TBrush( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Brush', 'TBrush' );
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Pen' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPen then begin
        Self.Pen := TPen( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Pen', 'TPen' );
    end else if CompareText( key, 'Shape' ) = 0 then begin
      Self.Shape := TShapeType(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyShape then
          with TPyShape(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyShape then
          with TPyShape(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyShape then
          with TPyShape(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyShape then
          with TPyShape(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyShape then
          with TPyShape(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyShape then
          with TPyShape(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyShape then
          with TPyShape(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TGraphicControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TPaintBox //////////////////

function TPaintBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPaintBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TPaintBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPaintBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPaintBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPaintBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPaintBox) then begin
      ErrorWrongExpectedType( argSelf, 'TPaintBox' );
      Exit;
    end;
    realObj := TPaintBox(obj);
    // Check attribute
    Result := TPaintBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TPaintBox_ReadAttribute( Self : TPaintBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'ExtCtrls', 'TCanvas' )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'ExtCtrls', 'TFont' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'ExtCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnPaint' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TGraphicControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TPaintBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPaintBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPaintBox) then begin
      ErrorWrongExpectedType( argSelf, 'TPaintBox' );
      Exit;
    end;
    realObj := TPaintBox(obj);
    // Check attribute
    Result := TPaintBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TPaintBox_WriteAttribute( Self : TPaintBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnPaint' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnPaint := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnPaint := EventOnPaint;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPaintBox then
          with TPyPaintBox(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TGraphicControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TImage //////////////////

function TImage_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyImage;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TImage.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyImage.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TImage_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TImage) then begin
      ErrorWrongExpectedType( argSelf, 'TImage' );
      Exit;
    end;
    realObj := TImage(obj);
    // Check attribute
    Result := TImage_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TImage_ReadAttribute( Self : TImage; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'ExtCtrls', 'TCanvas' )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'AutoSize' ) = 0 then Result := VariantAsPyObject( Self.AutoSize )
    else if CompareText( key, 'Center' ) = 0 then Result := VariantAsPyObject( Self.Center )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'IncrementalDisplay' ) = 0 then Result := VariantAsPyObject( Self.IncrementalDisplay )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'Picture' ) = 0 then Result := GetPythonObject( Self.Picture, 'ExtCtrls', 'TPicture' )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'ExtCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Stretch' ) = 0 then Result := VariantAsPyObject( Self.Stretch )
    else if CompareText( key, 'Transparent' ) = 0 then Result := VariantAsPyObject( Self.Transparent )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnProgress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TProgressEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TGraphicControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TImage_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TImage) then begin
      ErrorWrongExpectedType( argSelf, 'TImage' );
      Exit;
    end;
    realObj := TImage(obj);
    // Check attribute
    Result := TImage_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TImage_WriteAttribute( Self : TImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AutoSize' ) = 0 then begin
      Self.AutoSize := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Center' ) = 0 then begin
      Self.Center := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'IncrementalDisplay' ) = 0 then begin
      Self.IncrementalDisplay := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Picture' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPicture then begin
        Self.Picture := TPicture( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Picture', 'TPicture' );
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Stretch' ) = 0 then begin
      Self.Stretch := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Transparent' ) = 0 then begin
      Self.Transparent := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnProgress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnProgress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnProgress := EventOnProgress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImage then
          with TPyImage(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TGraphicControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TBevel //////////////////

function TBevel_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyBevel;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TBevel.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyBevel.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TBevel_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBevel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBevel) then begin
      ErrorWrongExpectedType( argSelf, 'TBevel' );
      Exit;
    end;
    realObj := TBevel(obj);
    // Check attribute
    Result := TBevel_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TBevel_ReadAttribute( Self : TBevel; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'Shape' ) = 0 then Result := VariantAsPyObject( Integer( Self.Shape ) )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Style' ) = 0 then Result := VariantAsPyObject( Integer( Self.Style ) )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else Result := TGraphicControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TBevel_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBevel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBevel) then begin
      ErrorWrongExpectedType( argSelf, 'TBevel' );
      Exit;
    end;
    realObj := TBevel(obj);
    // Check attribute
    Result := TBevel_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TBevel_WriteAttribute( Self : TBevel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Shape' ) = 0 then begin
      Self.Shape := TBevelShape(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Style' ) = 0 then begin
      Self.Style := TBevelStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TGraphicControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TTimer //////////////////

function TTimer_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyTimer;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TTimer.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyTimer.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TTimer_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TTimer;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TTimer) then begin
      ErrorWrongExpectedType( argSelf, 'TTimer' );
      Exit;
    end;
    realObj := TTimer(obj);
    // Check attribute
    Result := TTimer_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TTimer_ReadAttribute( Self : TTimer; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Interval' ) = 0 then Result := VariantAsPyObject( Self.Interval )
    else if CompareText( key, 'OnTimer' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TTimer_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TTimer;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TTimer) then begin
      ErrorWrongExpectedType( argSelf, 'TTimer' );
      Exit;
    end;
    realObj := TTimer(obj);
    // Check attribute
    Result := TTimer_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TTimer_WriteAttribute( Self : TTimer; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Interval' ) = 0 then begin
      Self.Interval := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnTimer' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnTimer := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyTimer then
          with TPyTimer(Self) do
            OnTimer := EventOnTimer;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomPanel //////////////////

function TCustomPanel_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomPanel;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomPanel.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomPanel.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomPanel_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomPanel;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomPanel.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomPanel.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomPanel_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomPanel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomPanel) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomPanel' );
      Exit;
    end;
    realObj := TCustomPanel(obj);
    // Check attribute
    Result := TCustomPanel_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomPanel_ReadAttribute( Self : TCustomPanel; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TCustomControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomPanel_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomPanel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomPanel) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomPanel' );
      Exit;
    end;
    realObj := TCustomPanel(obj);
    // Check attribute
    Result := TCustomPanel_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomPanel_WriteAttribute( Self : TCustomPanel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TCustomControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TPanel //////////////////

function TPanel_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPanel;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TPanel.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPanel.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPanel_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPanel;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TPanel.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPanel.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPanel_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPanel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPanel) then begin
      ErrorWrongExpectedType( argSelf, 'TPanel' );
      Exit;
    end;
    realObj := TPanel(obj);
    // Check attribute
    Result := TPanel_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TPanel_ReadAttribute( Self : TPanel; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Alignment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Alignment ) )
    else if CompareText( key, 'BevelInner' ) = 0 then Result := VariantAsPyObject( Integer( Self.BevelInner ) )
    else if CompareText( key, 'BevelOuter' ) = 0 then Result := VariantAsPyObject( Integer( Self.BevelOuter ) )
    else if CompareText( key, 'BevelWidth' ) = 0 then Result := VariantAsPyObject( Integer( Self.BevelWidth ) )
    else if CompareText( key, 'BorderWidth' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderWidth ) )
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'FullRepaint' ) = 0 then Result := VariantAsPyObject( Self.FullRepaint )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'ExtCtrls', 'TFont' )
    else if CompareText( key, 'Locked' ) = 0 then Result := VariantAsPyObject( Self.Locked )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'ExtCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnResize' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomPanel_ReadAttribute( Self, argSelf, key );
  end;
end;

function TPanel_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPanel;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPanel) then begin
      ErrorWrongExpectedType( argSelf, 'TPanel' );
      Exit;
    end;
    realObj := TPanel(obj);
    // Check attribute
    Result := TPanel_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TPanel_WriteAttribute( Self : TPanel; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Alignment' ) = 0 then begin
      Self.Alignment := TAlignment(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BevelInner' ) = 0 then begin
      Self.BevelInner := TPanelBevel(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BevelOuter' ) = 0 then begin
      Self.BevelOuter := TPanelBevel(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BevelWidth' ) = 0 then begin
      Self.BevelWidth := TBevelWidth(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderWidth' ) = 0 then begin
      Self.BorderWidth := TBorderWidth(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'FullRepaint' ) = 0 then begin
      Self.FullRepaint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'Locked' ) = 0 then begin
      Self.Locked := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnResize' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnResize := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnResize := EventOnResize;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPanel then
          with TPyPanel(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomPanel_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TPage //////////////////

function TPage_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPage;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TPage.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPage.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPage_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPage;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TPage.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPage.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPage_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPage) then begin
      ErrorWrongExpectedType( argSelf, 'TPage' );
      Exit;
    end;
    realObj := TPage(obj);
    // Check attribute
    Result := TPage_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TPage_ReadAttribute( Self : TPage; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else Result := TCustomControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TPage_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPage) then begin
      ErrorWrongExpectedType( argSelf, 'TPage' );
      Exit;
    end;
    realObj := TPage(obj);
    // Check attribute
    Result := TPage_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TPage_WriteAttribute( Self : TPage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Height' ) = 0 then begin
      Self.Height := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Width' ) = 0 then begin
      Self.Width := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TCustomControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TNotebook //////////////////

function TNotebook_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyNotebook;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TNotebook.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyNotebook.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TNotebook_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyNotebook;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TNotebook.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyNotebook.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TNotebook_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TNotebook;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TNotebook) then begin
      ErrorWrongExpectedType( argSelf, 'TNotebook' );
      Exit;
    end;
    realObj := TNotebook(obj);
    // Check attribute
    Result := TNotebook_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TNotebook_ReadAttribute( Self : TNotebook; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'ActivePage' ) = 0 then Result := VariantAsPyObject( Self.ActivePage )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'ExtCtrls', 'TFont' )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'PageIndex' ) = 0 then Result := VariantAsPyObject( Self.PageIndex )
    else if CompareText( key, 'Pages' ) = 0 then Result := GetPythonObject( Self.Pages, 'ExtCtrls', 'TStrings' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'ExtCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnPageChanged' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TNotebook_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TNotebook;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TNotebook) then begin
      ErrorWrongExpectedType( argSelf, 'TNotebook' );
      Exit;
    end;
    realObj := TNotebook(obj);
    // Check attribute
    Result := TNotebook_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TNotebook_WriteAttribute( Self : TNotebook; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'ActivePage' ) = 0 then begin
      Self.ActivePage := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PageIndex' ) = 0 then begin
      Self.PageIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Pages' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Pages := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Pages', 'TStrings' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnPageChanged' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnPageChanged := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnPageChanged := EventOnPageChanged;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyNotebook then
          with TPyNotebook(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class THeader //////////////////

function THeader_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyHeader;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:THeader.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyHeader.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function THeader_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyHeader;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:THeader.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyHeader.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function THeader_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : THeader;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is THeader) then begin
      ErrorWrongExpectedType( argSelf, 'THeader' );
      Exit;
    end;
    realObj := THeader(obj);
    // Check attribute
    Result := THeader_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function THeader_ReadAttribute( Self : THeader; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'AllowResize' ) = 0 then Result := VariantAsPyObject( Self.AllowResize )
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'ExtCtrls', 'TFont' )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'ExtCtrls', 'TPopupMenu' )
    else if CompareText( key, 'Sections' ) = 0 then Result := GetPythonObject( Self.Sections, 'ExtCtrls', 'TStrings' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnSizing' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TSectionEvent' ); Result := nil; end
    else if CompareText( key, 'OnSized' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TSectionEvent' ); Result := nil; end
    else Result := TCustomControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function THeader_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : THeader;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is THeader) then begin
      ErrorWrongExpectedType( argSelf, 'THeader' );
      Exit;
    end;
    realObj := THeader(obj);
    // Check attribute
    Result := THeader_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function THeader_WriteAttribute( Self : THeader; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AllowResize' ) = 0 then begin
      Self.AllowResize := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'Sections' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Sections := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Sections', 'TStrings' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnSizing' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnSizing := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyHeader then
          with TPyHeader(Self) do
            OnSizing := EventOnSizing;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnSized' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnSized := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyHeader then
          with TPyHeader(Self) do
            OnSized := EventOnSized;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomRadioGroup //////////////////

function TCustomRadioGroup_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomRadioGroup;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomRadioGroup.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomRadioGroup.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomRadioGroup_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomRadioGroup;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomRadioGroup.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomRadioGroup.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomRadioGroup_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomRadioGroup;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomRadioGroup) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomRadioGroup' );
      Exit;
    end;
    realObj := TCustomRadioGroup(obj);
    // Check attribute
    Result := TCustomRadioGroup_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomRadioGroup_ReadAttribute( Self : TCustomRadioGroup; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TCustomGroupBox_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomRadioGroup_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomRadioGroup;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomRadioGroup) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomRadioGroup' );
      Exit;
    end;
    realObj := TCustomRadioGroup(obj);
    // Check attribute
    Result := TCustomRadioGroup_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomRadioGroup_WriteAttribute( Self : TCustomRadioGroup; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TCustomGroupBox_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TRadioGroup //////////////////

function TRadioGroup_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyRadioGroup;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TRadioGroup.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyRadioGroup.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TRadioGroup_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyRadioGroup;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TRadioGroup.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyRadioGroup.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TRadioGroup_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TRadioGroup;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TRadioGroup) then begin
      ErrorWrongExpectedType( argSelf, 'TRadioGroup' );
      Exit;
    end;
    realObj := TRadioGroup(obj);
    // Check attribute
    Result := TRadioGroup_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TRadioGroup_ReadAttribute( Self : TRadioGroup; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Columns' ) = 0 then Result := VariantAsPyObject( Self.Columns )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'ExtCtrls', 'TFont' )
    else if CompareText( key, 'ItemIndex' ) = 0 then Result := VariantAsPyObject( Self.ItemIndex )
    else if CompareText( key, 'Items' ) = 0 then Result := GetPythonObject( Self.Items, 'ExtCtrls', 'TStrings' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'ExtCtrls', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnStartDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TStartDragEvent' ); Result := nil; end
    else Result := TCustomRadioGroup_ReadAttribute( Self, argSelf, key );
  end;
end;

function TRadioGroup_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TRadioGroup;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TRadioGroup) then begin
      ErrorWrongExpectedType( argSelf, 'TRadioGroup' );
      Exit;
    end;
    realObj := TRadioGroup(obj);
    // Check attribute
    Result := TRadioGroup_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TRadioGroup_WriteAttribute( Self : TRadioGroup; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Columns' ) = 0 then begin
      Self.Columns := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ItemIndex' ) = 0 then begin
      Self.ItemIndex := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Items' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TStrings then begin
        Self.Items := TStrings( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Items', 'TStrings' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioGroup then
          with TPyRadioGroup(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioGroup then
          with TPyRadioGroup(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioGroup then
          with TPyRadioGroup(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioGroup then
          with TPyRadioGroup(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioGroup then
          with TPyRadioGroup(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioGroup then
          with TPyRadioGroup(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnStartDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnStartDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyRadioGroup then
          with TPyRadioGroup(Self) do
            OnStartDrag := EventOnStartDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomRadioGroup_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TSplitter //////////////////

function TSplitter_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPySplitter;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TSplitter.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPySplitter.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TSplitter_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TSplitter;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TSplitter) then begin
      ErrorWrongExpectedType( argSelf, 'TSplitter' );
      Exit;
    end;
    realObj := TSplitter(obj);
    // Check attribute
    Result := TSplitter_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TSplitter_ReadAttribute( Self : TSplitter; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'Beveled' ) = 0 then Result := VariantAsPyObject( Self.Beveled )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'MinSize' ) = 0 then Result := VariantAsPyObject( Integer( Self.MinSize ) )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'OnMoved' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TGraphicControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TSplitter_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TSplitter;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TSplitter) then begin
      ErrorWrongExpectedType( argSelf, 'TSplitter' );
      Exit;
    end;
    realObj := TSplitter(obj);
    // Check attribute
    Result := TSplitter_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TSplitter_WriteAttribute( Self : TSplitter; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Beveled' ) = 0 then begin
      Self.Beveled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'MinSize' ) = 0 then begin
      Self.MinSize := NaturalNumber(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnMoved' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMoved := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPySplitter then
          with TPySplitter(Self) do
            OnMoved := EventOnMoved;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TGraphicControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_ExtCtrls.Initialize;
begin
  AddMethod( 'CreateShape', TShape_Create, '' );
  AddMethod( 'Shape_GetAttr', TShape_GetAttr, '' );
  AddMethod( 'Shape_SetAttr', TShape_SetAttr, '' );
  AddMethod( 'CreatePaintBox', TPaintBox_Create, '' );
  AddMethod( 'PaintBox_GetAttr', TPaintBox_GetAttr, '' );
  AddMethod( 'PaintBox_SetAttr', TPaintBox_SetAttr, '' );
  AddMethod( 'CreateImage', TImage_Create, '' );
  AddMethod( 'Image_GetAttr', TImage_GetAttr, '' );
  AddMethod( 'Image_SetAttr', TImage_SetAttr, '' );
  AddMethod( 'CreateBevel', TBevel_Create, '' );
  AddMethod( 'Bevel_GetAttr', TBevel_GetAttr, '' );
  AddMethod( 'Bevel_SetAttr', TBevel_SetAttr, '' );
  AddMethod( 'CreateTimer', TTimer_Create, '' );
  AddMethod( 'Timer_GetAttr', TTimer_GetAttr, '' );
  AddMethod( 'Timer_SetAttr', TTimer_SetAttr, '' );
  AddMethod( 'CreateCustomPanel', TCustomPanel_Create, '' );
  AddMethod( 'CreateParentedCustomPanel', TCustomPanel_CreateParented, '' );
  AddMethod( 'CustomPanel_GetAttr', TCustomPanel_GetAttr, '' );
  AddMethod( 'CustomPanel_SetAttr', TCustomPanel_SetAttr, '' );
  AddMethod( 'CreatePanel', TPanel_Create, '' );
  AddMethod( 'CreateParentedPanel', TPanel_CreateParented, '' );
  AddMethod( 'Panel_GetAttr', TPanel_GetAttr, '' );
  AddMethod( 'Panel_SetAttr', TPanel_SetAttr, '' );
  AddMethod( 'CreatePage', TPage_Create, '' );
  AddMethod( 'CreateParentedPage', TPage_CreateParented, '' );
  AddMethod( 'Page_GetAttr', TPage_GetAttr, '' );
  AddMethod( 'Page_SetAttr', TPage_SetAttr, '' );
  AddMethod( 'CreateNotebook', TNotebook_Create, '' );
  AddMethod( 'CreateParentedNotebook', TNotebook_CreateParented, '' );
  AddMethod( 'Notebook_GetAttr', TNotebook_GetAttr, '' );
  AddMethod( 'Notebook_SetAttr', TNotebook_SetAttr, '' );
  AddMethod( 'CreateHeader', THeader_Create, '' );
  AddMethod( 'CreateParentedHeader', THeader_CreateParented, '' );
  AddMethod( 'Header_GetAttr', THeader_GetAttr, '' );
  AddMethod( 'Header_SetAttr', THeader_SetAttr, '' );
  AddMethod( 'CreateCustomRadioGroup', TCustomRadioGroup_Create, '' );
  AddMethod( 'CreateParentedCustomRadioGroup', TCustomRadioGroup_CreateParented, '' );
  AddMethod( 'CustomRadioGroup_GetAttr', TCustomRadioGroup_GetAttr, '' );
  AddMethod( 'CustomRadioGroup_SetAttr', TCustomRadioGroup_SetAttr, '' );
  AddMethod( 'CreateRadioGroup', TRadioGroup_Create, '' );
  AddMethod( 'CreateParentedRadioGroup', TRadioGroup_CreateParented, '' );
  AddMethod( 'RadioGroup_GetAttr', TRadioGroup_GetAttr, '' );
  AddMethod( 'RadioGroup_SetAttr', TRadioGroup_SetAttr, '' );
  AddMethod( 'CreateSplitter', TSplitter_Create, '' );
  AddMethod( 'Splitter_GetAttr', TSplitter_GetAttr, '' );
  AddMethod( 'Splitter_SetAttr', TSplitter_SetAttr, '' );
  inherited;
end;

end.
