#
# Copyright (c) 1991, 1992, 1993, 1994 Xerox Corporation.  All Rights Reserved.
#
# Unlimited use, reproduction, and distribution of this software is
# permitted.  Any copy of this software must include both the above
# copyright notice of Xerox Corporation and this paragraph.  Any
# distribution of this software must comply with all applicable United
# States export control laws.  This software is made available AS IS,
# and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
# INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
# PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
# THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
# CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
# XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
#
# $Id: ilu.py,v 1.2 1998/05/12 01:04:00 jody Exp $
#

# Exceptions
from iluRt import		\
    IluGeneralError,		\
    IluProtocolError,		\
    IluUnimplementedMethodError

# Constants
from iluRt import		\
    FALSE,			\
    TRUE,			\
    FineTimeRate,		\
    Version

# Methods
from iluRt import		\
    SetCalloutExceptionHandler,	\
    SetDebugLevel,		\
    SetDebugLevelViaString,	\
    CreateServer,		\
    DefaultServer,		\
    ObjectOfSBH,		\
    LookupObject,		\
    ParseSBH,			\
    FormSBH,			\
    FindObject,			\
    RegisterCustomSurrogate,	\
    IOROfObject,		\
    CallerIdentity,		\
    RegisterInputHandler,	\
    RegisterOutputHandler,	\
    CreateLoopHandle,		\
    RunMainLoop,		\
    ExitMainLoop,		\
    SetMainLoop,		\
    DoSoon,			\
    LongReal,			\
    FineTime,			\
    FineTime_Now,		\
    CreateAlarm,                \
    CreatePipeline,		\
    SetPipeline,		\
    GetPipeline,		\
    SetSerializer,		\
    GetSerializer,		\
    SetPassport,		\
    GetPassport,		\
    CreatePassport,		\
    Pickle,			\
    Typecode,			\
    ThreadedOperation,		\
    SetFDBudget,		\
    GetFDBudget,		\
    TCPStatistics,		\
    TCPDefaultBufferSize,	\
    CORBA_Object,		\
    __types__

def UnregisterInputHandler (fd):
    RegisterInputHandler (fd, None)

def TypeName(cl):
    return cl._IluClass.name()

def TypeID(cl):
    return cl._IluClass.id()

def AutoImport(path=(), verbose=None):
	import iluimport
	iluimport.install(path, verbose)
