/* simple2.java  */
/* Chris Jacobi, January 23, 1997 2:39 pm PST */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: simple2.java,v 1.8 1997/07/22 00:36:10 larner Exp $ */

/*
 * A simple client program that demonstrates the use of the
 * Calculator stub module with a local implementation.
 */ 
 
/*
 * Run this like
 * java Tutorial.simple2 number [number...]
 */ 

package Tutorial;

public class simple2 {
    
    public static void main(String argv[]) {
        Tutorial.Calculator calc;  //Interface from stubbing...
        try {
            //create the calculator
            calc = new Tutorial.CalculatorImpl();
            if (calc==null) {
                 System.err.println("Couldn't create calculator");
                 System.exit(1);
            }
            //clear the calculator before using it
            if (argv.length<1) {
                calc.SetValue(0.0);
            } else {
                Double v = Double.valueOf(argv[0]);
                calc.SetValue(v.doubleValue());
            }
            //now loop over the arguments, adding each in turn
            int i = 1;
            while (i<argv.length) {
                Double v = Double.valueOf(argv[i]); //don't bother...
                calc.Divide(v.doubleValue());
                i = i+1;
            } 
            //and print the result
            System.out.println("the 'sum' is " + calc.GetValue());
        } catch (Tutorial.DivideByZero e) {
            System.err.println("raised DivideByZero exception: " + e);
        } catch (xerox.ilu.IluSystemException e) {
            System.err.println("raised IluSystemException exception: " + e);
        }
    } //main
    
} //simple2
