/* $Id: c-srvr.c,v 1.14 1997/11/18 22:02:03 spreitze Exp $ */
/* Last edited by Mike Spreitzer November 18, 1997 1:01 pm PST */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>	/* for sleep() */
#include <stdlib.h>	/* for exit() */
#include "ChgUp.h"

#define TIME ((unsigned long) time(ILU_NIL))

static unsigned int period;
static int      style;
/*
 * 0 = squeeze FD budget; 1 = change ports; 2 = close & restart
 * server
 */

static ilu_cardinal generation = 0;
static unsigned iterations = 2 * 1000 * 1000 * 1000;
static ILU_C_Server theServer = ILU_NIL;
static ChgUp_T  o1 = ILU_NIL, o2 = ILU_NIL;

static int      theStop = 0;
static ilu_refany theAlarm = ILU_NIL;
static ilu_boolean mt = (
#ifdef ILU_OS_THREADED
			 ilu_TRUE
#else
			 ilu_FALSE
#endif
);

static void SetStop(ilu_private rock)
{
  ILU_C_StopRun(&theStop);
}

static void MySleep(unsigned int period)
{
  if (mt)
    sleep(period);
  else {
    ilu_FineTime    now, diff, then;
    now = ilu_FineTime_Now();
    diff = ilu_FineTime_FromDouble(period);
    then = ilu_FineTime_Add(now, diff);
    ilu_SetAlarm(theAlarm, then, SetStop, ILU_NIL);
    ILU_C_StoppableRun(&theStop);
  }
  return;
}

ChgUp_T
server_ChgUp_T_GetBrother(ChgUp_T self, ILU_C_ENVIRONMENT * env)
{
  ChgUp_T         b = (ChgUp_T) ChgUp_T__GetUserData(self);
  return CORBA_Object_duplicate(b, env);
}

ilu_cardinal
server_ChgUp_T_GetGeneration(ChgUp_T self, ILU_C_ENVIRONMENT * env)
{
  ILU_C_SET_SUCCESSFUL(env);
  return generation;
}

static char    *pinfo = ILU_NIL;
static char *  *tinfo = ILU_NIL;

static void CreateEm()
{
  ilu_string      p1 = ILU_NIL, p2 = ILU_NIL;
  theServer = ILU_C_InitializeServer("ChgUp-Server", ILU_NIL,
				     pinfo, tinfo, ILU_NIL,
				     ilu_TRUE);
  o1 = ChgUp_T__CreateTrue("A", theServer, ILU_NIL);
  o2 = ChgUp_T__CreateTrue("B", theServer, o1);
  ChgUp_T__SetUserData(o1, o2);
  p1 = ILU_C_PublishObject(o1);
  p2 = ILU_C_PublishObject(o2);
  ilu_free(p1);
  ilu_free(p2);
  printf("A's SBH is %s\n", ILU_C_SBHOfObject(o1));
}

int
main(int ac, char **av)
{
  time_t          startT;
  char           *progname = av[0];
  char           *newtinfo[10] = {ILU_NIL};
  av++;
  ac--;
  while (ac > 2 && av[0][0] == '-') {
    if (strcmp(av[0], "-mt") == 0)
      ac--, av++, mt = ilu_TRUE;
    else if (strcmp(av[0], "-st") == 0)
      ac--, av++, mt = ilu_FALSE;
    else if (strcmp(av[0], "-p") == 0)
      pinfo = av[1], ac -= 2, av += 2;
    else if (strcmp(av[0], "-t") == 0) {
      int             j = 0;
      av++;
      ac--;
      tinfo = newtinfo;
      while (ac > 2 && av[0][0] != '-') {
	newtinfo[j++] = av[0];
	av++;
	ac--;
      };
      newtinfo[j] = ILU_NIL;
    } else
      goto usage;
  }
  if (ac != 2 && ac != 3)
    goto usage;
  if (sscanf(av[0], "%d", &style) != 1 || style < 0 || style > 2) {
    fprintf(stderr,
	    "Conversion of \"%s\" to {0, 1, 2} failed!\n",
	    av[0]);
    return 2;
  }
  if (sscanf(av[1], "%u", &period) != 1) {
    fprintf(stderr, "Conversion of \"%s\" to unsigned int failed!\n",
	    av[1]);
    return 3;
  }
  if (ac > 2 && sscanf(av[2], "%u", &iterations) != 1) {
    fprintf(stderr, "Conversion of \"%s\" to unsigned int failed!\n",
	    av[2]);
    return 4;
  }
  if (mt) {
#ifdef ILU_OS_THREADED
    ILU_C_USE_OS_THREADS;
#else
    fprintf(stderr, "Multi-threading not configured into ILU!\n");
    exit(1);
#endif
  }
  ChgUp__InitializeServer();
  CreateEm();
  theAlarm = ilu_CreateAlarm();
  printf("ChgUp server, style=%d, period=%u\n", style, period);
  startT = time(ILU_NIL);
  printf("%lu = %s", (unsigned long) startT, ctime(&startT));
  for (; generation < iterations; generation++) {
    ilu_cardinal    fdb;
    ILU_C_ENVIRONMENT env;
    MySleep(period);
    switch (style) {
    case 0:
      printf("\n");
      fdb = ilu_SetFDBudget(0);
      printf("%lu FD usage = %lu\n", TIME, fdb);
      fdb = ilu_SetFDBudget(32);
      break;
    case 1:
      fprintf(stderr, "Style 1 not implementable yet!\n");
      exit(1);
      break;
    case 2:
      printf("\n%lu Closing server...\n", TIME);
      ILU_C_CloseServer(theServer, ilu_TRUE, ILU_NIL, ILU_NIL, ILU_NIL,
			&env);
      if (!ILU_C_SUCCESSFUL(&env))
	printf("%lu close => exn %s\n", TIME, ILU_C_EXCEPTION_ID(&env));
      ILU_C_Server_release(theServer, &env);
      if (!ILU_C_SUCCESSFUL(&env))
	printf("%lu ILU_C_Server_release => exn %s\n", TIME,
	       ILU_C_EXCEPTION_ID(&env));
      CreateEm();
      printf("\n%lu Server restarted\n", TIME);
      break;
    default:
      fprintf(stderr, "Unexpected style %d\n", style);
    }
  }
  return -1;
usage:
  fprintf(stderr,
	  "Usage: %s [-mt|-st] [-p <pinfo>] [-t <tinfo>]", progname);
  fprintf(stderr,
	  " <style: {0, 1, 2}> <period: unsigned (secs)>");
  fprintf(stderr,
	  " [iterations]\n");
  return 1;
}
